package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.InfoManage;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePaginationDto;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import java.util.Date;
import org.apache.ibatis.annotations.Param;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 10:07
 * @description 资讯管理(InfoManage)表数据库访问层
 */
public interface InfoManageMapper extends BaseMapper<InfoManage> {

  /**
   * 分页获取资讯信息
   * @param page
   * @param dto
   * @return
   */
  Page<InfoManageVo> pageInfo(Page<InfoManageVo> page,
      @Param("dto") InfoManagePaginationDto dto,
      @Param("delFlag") String delFlag);

  /**
   * 增加资讯的阅读量
   * @param infoCode 资讯编码
   * @param step 增加的步长
   */
  void incrementReadNumByStep(@Param("infoCode") String infoCode,
      @Param("step") Integer step,
      @Param("modifyAccount") String modifyAccount,
      @Param("modifyName") String modifyName,
      @Param("modifyTime") Date modifyTime);
}
