package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.local.entity.LevelManage;
import com.biz.crm.member.business.member.sdk.dto.LevelManagePaginationDto;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 等级管理(LevelManage)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-13 09:51:35
 */
public interface LevelManageMapper extends BaseMapper<LevelManage> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<LevelManageVo> findByConditions(
      Page<LevelManageVo> page, @Param("dto") LevelManagePaginationDto dto);

  /**
   * 检查成长值区间
   * @param levelManageVo
   * @return
   */
  List<LevelManage> checkGrow(@Param("dto") LevelManageVo levelManageVo);
}

