package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoArchivesVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoArchives;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoArchivesPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 会员档案(MemberInfoArchives)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-19 14:32:21
 */
public interface MemberInfoArchivesMapper extends BaseMapper<MemberInfoArchives> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoArchivesVo> findByConditions(
      Page<MemberInfoArchivesVo> page, @Param("dto") MemberInfoArchivesPaginationDto dto);

}

