package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoAssets;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoAssetsPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 会员资产(MemberInfoAssets)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-19 14:32:52
 */
public interface MemberInfoAssetsMapper extends BaseMapper<MemberInfoAssets> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoAssetsVo> findByConditions(
      Page<MemberInfoAssetsVo> page, @Param("dto") MemberInfoAssetsPaginationDto dto);

}

