package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.BenefitsRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoBenefitsVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoBenefits;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoBenefitsPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefits;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefitsReqVo;
import org.apache.ibatis.annotations.Param;

/**
 * 会员权益关联表(MemberInfoBenefits)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-20 15:08:40
 */
public interface MemberInfoBenefitsMapper extends BaseMapper<MemberInfoBenefits> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoBenefitsVo> findByConditions(
      Page<MemberInfoBenefitsVo> page, @Param("dto") MemberInfoBenefitsPaginationDto dto);

  /**
   * 权益兑换列表
   * @param page
   * @param dto
   * @return
   */
  Page<AppletMemberInfoBenefits> getMemberInfoBenefitsList(Page<AppletMemberInfoBenefits> page,@Param("dto") AppletMemberInfoBenefitsReqVo dto);

  /**
   * 根据条件分页获取权限记录信息
   * @param page
   * @param dto
   * @param delFlag
   * @return
   */
  Page<MemberInfoBenefitsVo> pageByConditions(Page<MemberInfoBenefitsVo> page,
      @Param("dto") BenefitsRecordPaginationDto dto,
      @Param("delFlag") String delFlag,
      @Param("memberBenefitsType") String memberBenefitsType);
}

