package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoContactVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoContact;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoContactPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 业务员联系人(MemberInfoContact)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-19 14:33:17
 */
public interface MemberInfoContactMapper extends BaseMapper<MemberInfoContact> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoContactVo> findByConditions(
      Page<MemberInfoContactVo> page, @Param("dto") MemberInfoContactPaginationDto dto);

}

