package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.GrowRecordAPIPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationAPIDto;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoGrowRecord;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoGrowRecordPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 会员成长值变动记录(MemberInfoGrowRecord)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-19 14:33:37
 */
public interface MemberInfoGrowRecordMapper extends BaseMapper<MemberInfoGrowRecord> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoGrowRecordVo> findByConditions(
      Page<MemberInfoGrowRecordVo> page, @Param("dto") MemberInfoGrowRecordPaginationDto dto);

  /**
   * 小程序成长值记录分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<GrowRecordAPIVo> findByConditionsAPI(
      Page<GrowRecordAPIVo> page, @Param("dto") GrowRecordAPIPaginationDto dto);

}

