package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationAPIDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoIntegralRecord;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationDto;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 会员积分变动记录(MemberInfoIntegralRecord)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-19 14:34:02
 */
public interface MemberInfoIntegralRecordMapper extends BaseMapper<MemberInfoIntegralRecord> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoIntegralRecordVo> findByConditions(
      Page<MemberInfoIntegralRecordVo> page, @Param("dto") MemberInfoIntegralRecordPaginationDto dto);

  /**
   * 小程序分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoIntegralRecordAPIVo> findByConditionsAPI(
      Page<MemberInfoIntegralRecordAPIVo> page, @Param("dto") MemberInfoIntegralRecordPaginationAPIDto dto);

  Integer sumResidualIntegral(String memberCode, Date timeOpen, Date timeClose);

  /**
   * 根据记录类型和时间统计积分
   * @param addType
   * @param currentTime
   * @return
   */
  int sumIntegralByTypeAndTime(@Param("addType") List<String> addType,
      @Param("currentTime") String currentTime,
      @Param("delFlag") String delFlag);
}

