package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoLevelChangeRecord;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoLevelChangeRecordPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 会员等级变动记录(MemberInfoLevelChangeRecord)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-19 14:34:22
 */
public interface MemberInfoLevelChangeRecordMapper extends BaseMapper<MemberInfoLevelChangeRecord> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoLevelChangeRecordVo> findByConditions(
      Page<MemberInfoLevelChangeRecordVo> page, @Param("dto") MemberInfoLevelChangeRecordPaginationDto dto);

}

