package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.local.entity.MemberInfo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 会员信息(MemberInfo)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-19 14:31:57
 */
public interface MemberInfoMapper extends BaseMapper<MemberInfo> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoVo> findByConditions(
      Page<MemberInfoVo> page, @Param("dto") MemberInfoPaginationDto dto);

}

