package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordDetailVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoReceiptRecordDetail;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordDetailPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 会员签收记录产品明细(MemberInfoReceiptRecordDetail)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-28 16:55:58
 */
public interface MemberInfoReceiptRecordDetailMapper extends BaseMapper<MemberInfoReceiptRecordDetail> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoReceiptRecordDetailVo> findByConditions(
      Page<MemberInfoReceiptRecordDetailVo> page, @Param("dto") MemberInfoReceiptRecordDetailPaginationDto dto);

}

