package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoReceiptRecord;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 会员签收记录(MemberInfoReceiptRecord)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-28 16:55:36
 */
public interface MemberInfoReceiptRecordMapper extends BaseMapper<MemberInfoReceiptRecord> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoReceiptRecordVo> findByConditions(
      Page<MemberInfoReceiptRecordVo> page, @Param("dto") MemberInfoReceiptRecordPaginationDto dto);

}

