package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSignVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoSign;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoSignPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberSignCountVo;
import com.biz.crm.member.business.member.sdk.vo.MemberSignRecordVo;
import org.apache.ibatis.annotations.Param;

/**
 * 会员签到表(MemberInfoSign)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-27 13:44:50
 */
public interface MemberInfoSignMapper extends BaseMapper<MemberInfoSign> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoSignVo> findByConditions(
      Page<MemberInfoSignVo> page, @Param("dto") MemberInfoSignPaginationDto dto);

  /**
   * 统计所有签到发放积分
   * @return
   */
  MemberSignCountVo signCountNum();

  /**
   * 根据查询统计签到天数和签到积分
   * @param memberInfoSignPaginationDto
   * @return
   */
  MemberSignRecordVo querySignCountNum(@Param("dto") MemberInfoSignPaginationDto memberInfoSignPaginationDto);

  /**
   * 统计用户本年度获取到的积分
   * @param memberCode
   * @param currentYear
   * @return
   */
  Integer countUserYearIntegral(
      @Param("memberCode") String memberCode,
      @Param("currentYear") int currentYear);
}

