package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSupplyVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoSupply;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoSupplyPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 采供关系(MemberInfoSupply)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-19 14:34:41
 */
public interface MemberInfoSupplyMapper extends BaseMapper<MemberInfoSupply> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoSupplyVo> findByConditions(
      Page<MemberInfoSupplyVo> page, @Param("dto") MemberInfoSupplyPaginationDto dto);

}

