package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoTagVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoTag;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoTagPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 会员标签(MemberInfoTag)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-19 14:35:01
 */
public interface MemberInfoTagMapper extends BaseMapper<MemberInfoTag> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MemberInfoTagVo> findByConditions(
      Page<MemberInfoTagVo> page, @Param("dto") MemberInfoTagPaginationDto dto);

}

