package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.PrizeEntity;
import com.biz.crm.member.business.member.sdk.dto.PrizeDto;
import com.biz.crm.member.business.member.sdk.vo.PrizeVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 奖品mapper
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 14:38
 **/
public interface PrizeMapper extends BaseMapper<PrizeEntity> {

    /**
     * 分页查询奖品
     * @param page
     * @param prizeDto
     * @return
     */
    Page<PrizeVo> findByConditions(@Param("page") Page<PrizeVo> page, @Param("dto") PrizeDto prizeDto);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    PrizeVo findDetailById(@Param("id") String id);

    /**
     * 批量扣除奖品的库存
     * @param putMap
     */
    void updateInventory(@Param("params") Map<String, BigDecimal> putMap);

}
