package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.ProductCategory;
import com.biz.crm.member.business.member.sdk.dto.ProductCategoryDto;
import com.biz.crm.member.business.member.sdk.vo.ProductCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import org.apache.ibatis.annotations.Param;

/**
 * 商品分类数据访问层
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/14 16:30
 **/
public interface ProductCategoryMapper extends BaseMapper<ProductCategory> {

    /**
     * 分页查询
     * @param page
     * @param productCategoryDto
     * @return
     */
    Page<ProductCategoryVo> findByConditions(@Param("page") Page<ProductPageVo> page, @Param("dto") ProductCategoryDto productCategoryDto);

    void down(@Param("id") String id);


    void up(@Param("id") String id);

}
