package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.AppPointExchangeEntity;
import com.biz.crm.member.business.member.local.entity.Product;
import com.biz.crm.member.business.member.sdk.dto.AppPointStoreDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.biz.crm.member.business.member.sdk.vo.ProductVo;
import org.apache.ibatis.annotations.Param;

/**
 * 商品数据访问层
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 16:52
 **/
public interface ProductMapper extends BaseMapper<Product> {

    /**
     * 分页
     * @param page
     * @param productPageDto
     * @return
     */
    Page<ProductPageVo> findByConditions(Page<ProductPageVo> page, @Param("dto") ProductPageDto productPageDto);

    /**
     * 小程序商城分页
     * @param page
     * @param productPageDto
     * @return
     */
    Page<ProductPageVo> findByConditionsByApplet(Page<ProductPageVo> page, @Param("dto") ProductPageDto productPageDto);

    /**
     * 小程序商城商品详情查询
     * @param id
     * @return
     */
    ProductVo findAppletDetailById(@Param("id") String id);

    /**
     * 小程序商城商品查询指定用户指定商品可用兑换次数
     * @param dto
     * @return
     */
    AppPointExchangeEntity findAvailableCount(@Param("dto") AppPointStoreDto dto);

}
