package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.member.business.member.local.entity.Questionnaire;
import com.biz.crm.member.business.member.sdk.dto.QuestionnairePaginationDto;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireVo;
import java.util.List;
import liquibase.pro.packaged.S;
import org.apache.ibatis.annotations.Param;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 14:45
 * @description 问卷管理(Questionnaire)表操作层
 */
public interface QuestionnaireMapper extends BaseMapper<Questionnaire> {

  /**
   * 分页获取问卷信息
   * @param page
   * @param dto
   * @return
   */
  Page<QuestionnaireVo> pageInfo(Page<QuestionnaireVo> page,@Param("dto") QuestionnairePaginationDto dto,
      @Param("delFlag") String delFlag);

  /**
   * 小程序分页获取指定用户已提交的调查问卷信息
   * @param page
   * @param userAccount
   * @param delFlag
   * @return
   */
  Page<QuestionnaireVo> pageQuestionnaireByUserAccount(Page<QuestionnaireVo> page,
      @Param("userAccount") String userAccount,
      @Param("delFlag") String delFlag);

  /**
   * 小程序分页获取问卷信息
   * @param page
   * @param pubStatus
   * @param enableStatus
   * @param delFlag
   * @return
   */
  Page<QuestionnaireVo> appPageByPubStatusWithEnableStatus(Page<QuestionnaireVo> page,
      @Param("pubStatus") String pubStatus,
      @Param("enableStatus") String enableStatus,
      @Param("delFlag") String delFlag,
      @Param("noPublish") String noStarted,
      @Param("submitQuestionnaireCodes") List<String> submitQuestionnaireCodes);
}
