package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.RafflePrizeRecord;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.StaticsPrizeVo;
import org.apache.ibatis.annotations.Param;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 13:56
 **/
public interface RafflePrizeRecordMapper extends BaseMapper<RafflePrizeRecord> {

    /**
     * 后台中奖记录分页查询
     * @param page
     * @param rafflePrizeRecordDto
     * @return
     */
    Page<RafflePrizeRecordVo> findByConditions(@Param("page") Page<RafflePrizeRecordVo> page,@Param("dto") RafflePrizeRecordDto rafflePrizeRecordDto);

    /**
     * 小程序中奖记录分页查询
     * @param page
     * @param rafflePrizeRecordDto
     * @return
     */
    Page<RafflePrizeRecordVo> findByConditionsByApplet(@Param("page") Page<RafflePrizeRecordVo> page,@Param("dto") RafflePrizeRecordDto rafflePrizeRecordDto);

    /**
     * 统计奖品中奖数量
     * @param prizeCode
     * @return
     */
    StaticsPrizeVo staticsByStatus(@Param("prizeCode") String prizeCode);
}
