package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.RealAndDummyOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.RealAndDummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import com.biz.crm.member.business.member.local.entity.RealOrder;
import com.biz.crm.member.business.member.sdk.dto.RealOrderPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 实物订单(RealOrder)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-14 14:53:16
 */
public interface RealOrderMapper extends BaseMapper<RealOrder> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<RealOrderVo> findByConditions(
      Page<RealOrderVo> page, @Param("dto") RealOrderPaginationDto dto);

  /**
   * 小程序个人中心分页获取真实订单
   * @param page
   * @param dto
   * @param memberCode
   * @param delFlag
   * @return
   */
  Page<RealOrderVo> appPageRealOrder(Page<RealOrderVo> page,
      @Param("dto") AppOrderPaginationDto dto,
      @Param("memberCode") String memberCode,
      @Param("delFlag") String delFlag);

  /**
   * 小程序个人中心分页获取实物订单根据salesmanCode和orderStatus
   * @param page
   * @param orderStatus
   * @param salesmanCode
   * @param delFlag
   * @return
   */
  Page<RealOrderVo> appPageRealOrderBySalesmanCode(Page<RealOrderVo> page,
      @Param("orderStatus") String orderStatus,
      @Param("salesmanCode") String salesmanCode,
      @Param("delFlag") String delFlag);

  /**
   * 小程序分页获取指定组织编码的分发订单
   * @param page
   * @param orderStatus
   * @param orgCode
   * @param delFlag
   * @return
   */
  Page<RealOrderVo> appPageDispatchOrder(Page<RealOrderVo> page,
      @Param("orderStatus") String orderStatus,
      @Param("orgCode") String orgCode,
      @Param("delFlag") String delFlag);

  /**
   * 分页查询
   * @param page
   * @param dto
   * @return
   */
  Page<RealAndDummyOrderVo> findByConditionsRealAndOrder(Page<RealAndDummyOrderVo> page,@Param("dto") RealAndDummyOrderPaginationDto dto);
}

