package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleVo;
import com.biz.crm.member.business.member.local.entity.SignInRule;
import com.biz.crm.member.business.member.sdk.dto.SignInRulePaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 签到规则(SignInRule)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-15 16:47:20
 */
public interface SignInRuleMapper extends BaseMapper<SignInRule> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<SignInRuleVo> findByConditions(
      Page<SignInRuleVo> page, @Param("dto") SignInRulePaginationDto dto);

}

