package com.biz.crm.member.business.member.local.observer;

import com.biz.crm.member.business.member.local.entity.ActivityApplyRecord;
import com.biz.crm.member.business.member.local.entity.ActivityManage;
import com.biz.crm.member.business.member.local.repository.ActivityApplyRecordRepository;
import com.biz.crm.member.business.member.local.repository.ActivityManageRepository;
import com.biz.crm.member.business.member.local.service.ActivityApplyRecordService;
import com.biz.crm.member.business.member.sdk.constants.ActivityConstants;
import com.biz.crm.member.business.member.sdk.vo.ActivityApplyRecordVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 *@description: 小程序活动报名审批回调方法 修改审批状态
*@Time:2023/6/27 17:39
*/
@Slf4j
@Component
@Transactional
public class ProcessCompleteListenerOfActivity implements ProcessCompleteListener {

  @Autowired
  ActivityApplyRecordService activityApplyRecordService;
  @Autowired
  ActivityApplyRecordRepository activityApplyRecordRepository;
  @Autowired
  private RedisMutexService redisMutexService;
  @Autowired
  private ActivityManageRepository activityManageRepository;

  @Override
  public String getBusinessCode() {
    return ActivityConstants.APPLET_ACT_WORK_FLOW;
  }

  @Override
  public void onProcessComplete(ProcessStatusDto dto) {
    if (!dto.getBusinessCode().equals(ActivityConstants.APPLET_ACT_WORK_FLOW)) {
      return;
    }
    // 校验单号
    ActivityApplyRecord recordVo = this.activityApplyRecordRepository.getById(dto.getBusinessNo());
    Validate.notNull(recordVo, "报名记录不存在！");
    // 根据回调类别处理对应业务
    if (StringUtils.equals(
            String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.PASS.getDictCode())) {
      // 审批通过
      recordVo.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
    } else if (StringUtils.equals(
            String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.REJECT.getDictCode())) {
      // 审批驳回
      recordVo.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
    } else if (StringUtils.equals(
            String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.RECOVER.getDictCode())) {
      // 流程追回
      recordVo.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
    }
    recordVo.setApprovalDate(new Date());
    this.activityApplyRecordRepository.updateById(recordVo);
    //审批通过业务处理
    if (StringUtils.equals(String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.PASS.getDictCode())) {
      boolean locked = false;
      try {
        locked = redisMutexService.tryLock(recordVo.getActivityCode(), TimeUnit.SECONDS, 5);
        Validate.isTrue(locked, "业务繁忙，请稍候再试。");
        //校验是否超出报名最大额度
        ActivityManage act = this.activityManageRepository.lambdaQuery().eq(ActivityManage::getCode, recordVo.getActivityCode()).one();
        Integer currentCount = ObjectUtils.defaultIfNull(act.getHasJoin(), 0);
        Validate.isTrue(currentCount < act.getApplyCeilingNum(), "抱歉，报名名额已用完！");
        //更新报名人数
        act.setHasJoin(currentCount + 1);
        this.activityManageRepository.saveOrUpdate(act);
      } catch (Exception e) {
        throw new RuntimeException(e);
      } finally {
        if (locked) {
          redisMutexService.unlock(recordVo.getActivityCode());
        }
      }
    }
  }
}
