package com.biz.crm.member.business.member.local.observer;

import com.biz.crm.member.business.member.local.entity.DummyOrder;
import com.biz.crm.member.business.member.local.repository.DummyOrderRepository;
import com.biz.crm.member.business.member.sdk.constants.ProcessConstant;
import com.biz.crm.member.business.member.sdk.enums.OrderSettleStatusEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 虚拟订单审批回调
 */
@Component
public class ProcessCompleteListenerOfDummyOrder implements ProcessCompleteListener {

  @Autowired(required = false)
  private DummyOrderRepository dummyOrderRepository;

  @Override
  @Transactional
  public void onProcessComplete(ProcessStatusDto dto) {
    if (!dto.getBusinessCode().equals(ProcessConstant.MMS_REAL_ORDER_CREATE)) {
      return;
    }
    // 校验单号(查询方法缺失)
    DummyOrder dummyOrder = this.dummyOrderRepository.getById(dto.getBusinessNo());
    if (ObjectUtils.isEmpty(dummyOrder)) {
      return;
    }
    // 校验审批状态
    Validate.isTrue(
        dummyOrder.getProcessStatus().equals(ProcessStatusEnum.COMMIT.getDictCode()),
        "此虚拟订单非审批中状态，无法进行操作！");
    // 根据回调类别处理对应业务
    if (StringUtils.equals(
        String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.PASS.getDictCode())) {
      // 审批通过业务处理
      dummyOrder.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
      dummyOrder.setSettleStatus(OrderSettleStatusEnum.HAS_SETTLE.getValue());
    } else if (StringUtils.equals(
        String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.REJECT.getDictCode())) {
      // 审批驳回业务处理
      dummyOrder.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
      dummyOrder.setSettleStatus(OrderSettleStatusEnum.REJECT_SETTLE.getValue());
    } else if (StringUtils.equals(
        String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.RECOVER.getDictCode())) {
      // 流程追回业务处理
      dummyOrder.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
      dummyOrder.setSettleStatus(OrderSettleStatusEnum.REJECT_SETTLE.getValue());
    }
    this.dummyOrderRepository.updateById(dummyOrder);
  }

  @Override
  public String getBusinessCode() {
    return ProcessConstant.MMS_DUMMY_ORDER_CREATE;
  }
}
