package com.biz.crm.member.business.member.local.observer;

import com.biz.crm.member.business.member.local.entity.RealOrder;
import com.biz.crm.member.business.member.local.repository.RealOrderRepository;
import com.biz.crm.member.business.member.sdk.constants.ProcessConstant;
import com.biz.crm.member.business.member.sdk.enums.OrderSettleStatusEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 实物订单审批回调
 */
@Component
public class ProcessCompleteListenerOfRealOrder implements ProcessCompleteListener {

  @Autowired(required = false)
  private RealOrderRepository realOrderRepository;

  @Override
  @Transactional
  public void onProcessComplete(ProcessStatusDto dto) {
    if (!dto.getBusinessCode().equals(ProcessConstant.MMS_REAL_ORDER_CREATE)) {
      return;
    }
    // 校验单号(查询方法缺失)
    RealOrder realOrder = this.realOrderRepository.getById(dto.getBusinessNo());
    if (ObjectUtils.isEmpty(realOrder)) {
      return;
    }
    // 校验审批状态
    Validate.isTrue(
        realOrder.getProcessStatus().equals(ProcessStatusEnum.COMMIT.getDictCode()),
        "此实物订单非审批中状态，无法进行操作！");
    // 根据回调类别处理对应业务
    if (StringUtils.equals(
        String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.PASS.getDictCode())) {
      // 审批通过业务处理
      realOrder.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
      realOrder.setSettleStatus(OrderSettleStatusEnum.HAS_SETTLE.getValue());
    } else if (StringUtils.equals(
        String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.REJECT.getDictCode())) {
      // 审批驳回业务处理
      realOrder.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
      realOrder.setSettleStatus(OrderSettleStatusEnum.REJECT_SETTLE.getValue());
    } else if (StringUtils.equals(
        String.valueOf(dto.getProcessStatus()), ProcessStatusEnum.RECOVER.getDictCode())) {
      // 流程追回业务处理
      realOrder.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
      realOrder.setSettleStatus(OrderSettleStatusEnum.REJECT_SETTLE.getValue());
    }
    this.realOrderRepository.updateById(realOrder);
  }

  @Override
  public String getBusinessCode() {
    return ProcessConstant.MMS_REAL_ORDER_CREATE;
  }
}
