package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.member.business.member.local.entity.AnswerRecord;
import com.biz.crm.member.business.member.local.mapper.AnswerRecordMapper;
import com.biz.crm.member.business.member.sdk.dto.AnswerRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.AnswerRecordVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionCountVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionStatisticVo;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/21 15:15
 * @description 用户答题记录(repository)
 */
@Component
public class AnswerRecordRepository extends ServiceImpl<AnswerRecordMapper, AnswerRecord> {


  /**
   * 统计题目答案个数
   *
   * @param questionCodes
   * @return
   */
  public List<QuestionStatisticVo> statisticQuestion(List<String> questionCodes) {

    return baseMapper.statisticQuestion(questionCodes, DelFlagStatusEnum.NORMAL.getCode());
  }

  /**
   * 根据题目编码分页获取答题记录
   * @param page
   * @param dto
   * @return
   */
  public Page<AnswerRecordVo> pageAnswerRecord(Page<AnswerRecordVo> page, AnswerRecordPaginationDto dto) {
    return baseMapper.pageAnswerRecord(page, dto, DelFlagStatusEnum.NORMAL.getCode());
  }

}
