package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.local.mapper.BenefitsManageOrgMapper;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManageOrgPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 权益管理-区域有效期配置(repository)
 *
 * @author zouhs
 * @date 2023-06-12 12:39:28
 */
@Component
public class BenefitsManageOrgRepository extends ServiceImpl<BenefitsManageOrgMapper, BenefitsManageOrg> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<BenefitsManageOrgVo> findByConditions(Page<BenefitsManageOrgVo> page, BenefitsManageOrgPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public BenefitsManageOrg findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<BenefitsManageOrg> findByIds(List<String> ids) {
    return this.lambdaQuery().in(BenefitsManageOrg::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(BenefitsManageOrg::getId, ids)
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(BenefitsManageOrg::getId, ids)
        .remove();
  }
}
