package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.local.entity.BenefitsManage;
import com.biz.crm.member.business.member.local.mapper.BenefitsManageMapper;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 权益管理(repository)
 *
 * @author zouhs
 * @date 2023-06-12 12:29:46
 */
@Component
public class BenefitsManageRepository extends ServiceImpl<BenefitsManageMapper, BenefitsManage> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<BenefitsManageVo> findByConditions(Page<BenefitsManageVo> page, BenefitsManagePaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public BenefitsManage findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<BenefitsManage> findByIds(List<String> ids) {
    return this.lambdaQuery().in(BenefitsManage::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(BenefitsManage::getId, ids)
        .set(BenefitsManage::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(BenefitsManage::getId, ids)
        .set(BenefitsManage::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
