package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.ChoiceNessCategory;
import com.biz.crm.member.business.member.local.mapper.ChoiceNessCategoryMapper;
import com.biz.crm.member.business.member.sdk.dto.ChoiceNessCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.ChoiceNessCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.InfoCategoryVo;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 17:02
 * @description 精选分类管理(repository)
 */
@Component
public class ChoiceNessCategoryRepository extends ServiceImpl<ChoiceNessCategoryMapper, ChoiceNessCategory> {

  /**
   * 分页获取精选分类信息
   * @param page
   * @param dto
   * @return
   */
  public Page<ChoiceNessCategoryVo> pageChoiceNessCategory(Page<ChoiceNessCategoryVo> page,
      ChoiceNessCategoryPaginationDto dto) {
    ChoiceNessCategoryMapper baseMapper = this.getBaseMapper();
    return baseMapper.pageChoiceNessCategory(page, dto, DelFlagStatusEnum.NORMAL.getCode());
  }

  /**
   * 修改精选分类的状态 启用||禁用
   * @param ids
   * @param enable
   */
  public void batchUpdateStatus(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(ChoiceNessCategory::getId, ids)
        .set(ChoiceNessCategory::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 批量逻辑删除精选分类信息
   * @param ids
   */
  public void batchLogicDeleteCategory(List<String> ids) {
    this.lambdaUpdate()
        .in(ChoiceNessCategory::getId, ids)
        .set(ChoiceNessCategory::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
