package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.BenefitsManage;
import com.biz.crm.member.business.member.local.entity.CulturalAndTourismTopic;
import com.biz.crm.member.business.member.local.mapper.CulturalAndTourismTopicMapper;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismTopicPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismTopicVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author hupan
 * @date 2023/6/19 13:38
 */
@Component
public class CulturalAndTourismTopicRepository extends
    ServiceImpl<CulturalAndTourismTopicMapper, CulturalAndTourismTopic> {

  @Autowired
  private CulturalAndTourismTopicMapper culturalAndTourismTopicMapper;

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<CulturalAndTourismTopicVo> findByConditions(Page<CulturalAndTourismTopicVo> page, CulturalAndTourismTopicPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(CulturalAndTourismTopic::getId, ids)
        .set(CulturalAndTourismTopic::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(CulturalAndTourismTopic::getId, ids)
        .set(CulturalAndTourismTopic::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  public CulturalAndTourismTopic selectRandOne(){
    return culturalAndTourismTopicMapper.selectRandOne();
  }
}
