package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.member.business.member.local.entity.DeliveryPermissionManage;
import com.biz.crm.member.business.member.local.mapper.DeliveryPermissionManageMapper;
import com.biz.crm.member.business.member.sdk.dto.DeliveryPermissionManageDto;
import com.biz.crm.member.business.member.sdk.vo.DeliveryPermissionManageVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @author hupan
 * @date 2023/6/15 10:59
 */
@Component
public class DeliveryPermissionManageRepository extends
    ServiceImpl<DeliveryPermissionManageMapper, DeliveryPermissionManage> {


  /**
   * 分页条件查询
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<DeliveryPermissionManageVo> findByConditions(Page<DeliveryPermissionManageVo> page,
      DeliveryPermissionManageDto dto) {
    return this.baseMapper.findByConditions(page,dto);
  }

  /**
   * 批量添加
   *
   * @param list
   */
//  void addBatch(List<DeliveryPermissionManageDto> list){
//    this.saveBatch(list);
//  }

  /**
   * 批量开启配送权限
   */
  public void enableBatch(List<String> ids){
    this.lambdaUpdate()
        .in(DeliveryPermissionManage::getId,ids)
        .set(DeliveryPermissionManage::getHasSelfDeliveryPermission,1)
        .update();
  }

  /**
   * 批量关闭配送权限
   */
  public void disableBatch(List<String> ids){
    this.lambdaUpdate()
        .in(DeliveryPermissionManage::getId,ids)
        .set(DeliveryPermissionManage::getHasSelfDeliveryPermission,0)
        .update();
  }
}
