package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.Discuss;
import com.biz.crm.member.business.member.local.mapper.DiscussMapper;
import com.biz.crm.member.business.member.sdk.dto.DiscussPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.DiscussCheckStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.DiscussVo;
import com.biz.crm.member.business.member.sdk.vo.InfoCountDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 14:06
 * @description 评论管理(repository)
 */
@Component
public class DiscussRepository extends ServiceImpl<DiscussMapper, Discuss> {

  /**
   * 批量逻辑删除评论
   * @param ids
   */
  public void logicDeleteByIds(List<String> ids) {
    this.lambdaUpdate()
        .set(Discuss::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .in(Discuss::getId, ids)
        .update();
  }

  /**
   * 批量修改审批状态
   * @param ids id集合
   * @param checkStatus 审批状态
   */
  public void modifyCheckStatusByIds(List<String> ids, String checkStatus) {
    this.lambdaUpdate()
        .set(Discuss::getCheckStatus, checkStatus)
        .in(Discuss::getId, ids)
        .update();
  }

  /**
   * 批量修改批量启用||禁用状态
   * @param ids
   * @param enable
   */
  public void modifyEnableStatus(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .set(Discuss::getEnableStatus, enable.getCode())
        .in(Discuss::getId, ids)
        .update();
  }

  /**
   * 批量精选评论
   * @param ids
   */
  public void modifyChoiceDiscuss(List<String> ids, Integer choiceDiscuss) {
    this.lambdaUpdate()
        .set(Discuss::getChoiceDiscuss, choiceDiscuss)
        .in(Discuss::getId, ids)
        .update();
  }

  /**
   * 分页获取评论信息
   * @param page
   * @param dto
   * @return
   */
  public Page<DiscussVo> pageDiscussInfo(Page<DiscussVo> page, DiscussPaginationDto dto) {
    return this.baseMapper.pageDiscussInfo(page, dto, DelFlagStatusEnum.NORMAL.getCode());
  }

  /**
   * 分组统计资讯评论数量
   * @param infoCodes
   * @return
   */
  public List<InfoCountDto> countByInfoCodes(List<String> infoCodes, String checkStatus, String enableStatus){
    return this.baseMapper.countByInfoCode(infoCodes,
        DelFlagStatusEnum.NORMAL.getCode(),
        checkStatus,
        enableStatus);
  }

  /**
   * 小程序分页获取资讯的评论信息
   * @param page
   * @param infoCode
   * @param memberCode
   * @return
   */
  public Page<DiscussVo> appPageDiscussByInfoCode(Page<DiscussVo> page, String infoCode, String memberCode) {
    return baseMapper.appPageDiscussByInfoCode(page,
        infoCode,
        memberCode,
        DelFlagStatusEnum.NORMAL.getCode(),
        DiscussCheckStatusEnum.APPROVE.getValue(),
        EnableStatusEnum.ENABLE.getCode());
  }
}
