package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.DummyOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.local.entity.DummyOrder;
import com.biz.crm.member.business.member.local.mapper.DummyOrderMapper;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 虚拟订单(repository)
 *
 * @author zouhs
 * @date 2023-06-14 15:00:59
 */
@Component
public class DummyOrderRepository extends ServiceImpl<DummyOrderMapper, DummyOrder> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<DummyOrderVo> findByConditions(Page<DummyOrderVo> page, DummyOrderPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public DummyOrder findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<DummyOrder> findByIds(List<String> ids) {
    return this.lambdaQuery().in(DummyOrder::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(DummyOrder::getId, ids)
        .set(DummyOrder::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(DummyOrder::getId, ids)
        .set(DummyOrder::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  public void updateWriteOffByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(DummyOrder::getId, ids)
        .eq(DummyOrder::getOrderStatus, DummyOrderStatusEnum.STAY_USE.getValue())
        .set(DummyOrder::getOrderStatus, DummyOrderStatusEnum.HAS_WRITE_OFF.getValue())
        .update();
  }

  /**
   * 小程序分页获取虚拟订单
   * @param page
   * @param dto
   * @param memberCode
   * @return
   */
  public Page<DummyOrderVo> appPageDummyOrder(Page<DummyOrderVo> page, AppOrderPaginationDto dto, String memberCode) {
    return this.baseMapper.appPageDummyOrder(page, dto, memberCode, DelFlagStatusEnum.NORMAL.getCode());
  }
}
