package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderApplyUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.biz.crm.member.business.member.local.entity.DummyOrderUser;
import com.biz.crm.member.business.member.local.mapper.DummyOrderUserMapper;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderUserPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 虚拟订单用户信息(repository)
 *
 * @author zouhs
 * @date 2023-06-14 15:01:25
 */
@Component
public class DummyOrderUserRepository extends ServiceImpl<DummyOrderUserMapper, DummyOrderUser> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<DummyOrderUserVo> findByConditions(Page<DummyOrderUserVo> page, DummyOrderUserPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public DummyOrderUser findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<DummyOrderUser> findByIds(List<String> ids) {
    return this.lambdaQuery().in(DummyOrderUser::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(DummyOrderUser::getId, ids)
        .set(DummyOrderUser::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(DummyOrderUser::getId, ids)
        .set(DummyOrderUser::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  public Page<DummyOrderApplyUserVo> findDummyOrderUserApplyByConditions(Page<DummyOrderApplyUserVo> page, DummyOrderUserPaginationDto dto) {
    return this.baseMapper.findDummyOrderUserApplyByConditions(page, dto);
  }
}
