package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.InfoCategory;
import com.biz.crm.member.business.member.local.mapper.InfoCategoryMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 11:01
 * @description 资讯分类管理(repository)
 */
@Component
public class InfoCategoryRepository extends ServiceImpl<InfoCategoryMapper, InfoCategory> {

  /**
   * 根据id集合修改资讯分类启用||禁用状态
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(InfoCategory::getId, ids)
        .set(InfoCategory::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 根据id集合批量逻辑删除资讯分类
   * @param ids
   */
  public void logicDeleteInfoCategoryByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(InfoCategory::getId, ids)
        .set(InfoCategory::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
