package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.InfoManage;
import com.biz.crm.member.business.member.local.mapper.InfoManageMapper;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePaginationDto;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 10:09
 * @description 资讯管理(repository)
 */
@Component
public class InfoManageRepository extends ServiceImpl<InfoManageMapper, InfoManage> {

  /**
   * 根据id逻辑删除
   * @param ids
   */
  public void logicDeleteByIds(List<String> ids) {
    lambdaUpdate()
        .set(InfoManage::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .in(InfoManage::getId, ids)
        .update();
  }

  /**
   * 根据id修改状态 启用||禁用
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    lambdaUpdate()
        .set(InfoManage::getEnableStatus, enable.getCode())
        .in(InfoManage::getId, ids)
        .update();
  }

  /**
   * 分页获取资讯信息
   * @param page
   * @param dto
   * @return
   */
  public Page<InfoManageVo> pageInfo(Page<InfoManageVo> page, InfoManagePaginationDto dto) {
    return baseMapper.pageInfo(page, dto, DelFlagStatusEnum.NORMAL.getCode());
  }

  /**
   * 增加资讯的阅读量
   * @param infoCode 资讯编码
   * @param step 增加的步长
   */
  public void incrementReadNumByStep(String infoCode, Integer step, String modifyAccount, String modifyName, Date modifyTime) {
    this.baseMapper.incrementReadNumByStep(infoCode, step, modifyAccount, modifyName, modifyTime);
  }
}
