package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.member.business.member.local.entity.InfoUpvote;
import com.biz.crm.member.business.member.local.mapper.InfoUpvoteMapper;
import org.springframework.stereotype.Component;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 16:18
 * @description 资讯点赞量(repository)
 */
@Component
public class InfoUpvoteRepository extends ServiceImpl<InfoUpvoteMapper, InfoUpvote> {

  /**
   * 取消点赞
   * @param infoCode
   * @param memberCode
   */
  public void cancelUpvoteByInfoCode(String infoCode, String memberCode) {
    this.lambdaUpdate()
        .set(InfoUpvote::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .eq(InfoUpvote::getInfoCode, infoCode)
        .eq(InfoUpvote::getMemberCode, memberCode)
        .update();
  }
}
