package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.BenefitsManage;
import com.biz.crm.member.business.member.local.entity.LabelCategory;
import com.biz.crm.member.business.member.local.mapper.LabelCategoryMapper;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.LabelCategoryDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.LabelCategoryVo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author hupan
 * @date 2023/6/15 10:55
 */
@Component
public class LabelCategoryRepository extends ServiceImpl<LabelCategoryMapper, LabelCategory> {

  /**
   * 分页
   *
   * @param page
   * @param labelCategoryVo
   * @return
   */
  public Page<LabelCategoryVo> findByConditions(Page<LabelCategoryVo> page, LabelCategoryVo labelCategoryVo) {
    return this.baseMapper.findByConditions(page, labelCategoryVo);
  }
  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(LabelCategory::getId, ids)
        .set(LabelCategory::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(LabelCategory::getId, ids)
        .set(LabelCategory::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 下拉框接口
   * @return
   */
  public List<LabelCategory> findByConditions(){
    return this.lambdaQuery()
        .eq(LabelCategory::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .list();
  }

  /**
   * 标签移动
   */
  public void updateSort(String id,Integer sort){
    this.lambdaUpdate()
        .eq(LabelCategory::getId,id)
        .set(LabelCategory::getSort,sort)
        .update();
  }
}
