package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.BenefitsManage;
import com.biz.crm.member.business.member.local.entity.Label;
import com.biz.crm.member.business.member.local.mapper.LabelMapper;
import com.biz.crm.member.business.member.sdk.dto.LabelDetailDto;
import com.biz.crm.member.business.member.sdk.dto.LabelPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.LabelDetailVo;
import com.biz.crm.member.business.member.sdk.vo.LabelVo;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author hupan
 * @date 2023/6/15 10:56
 */
@Component
public class LabelRepository extends ServiceImpl<LabelMapper, Label> {

  public Page<LabelVo> findByConditions(Page<LabelVo> page,
      LabelPaginationDto labelPaginationDto){
    return this.baseMapper.findByConditions(page,labelPaginationDto);
  }

  public void insert(Label label){
    this.baseMapper.insert(label);
  }

  public boolean updateById(Label label){
    int i = this.baseMapper.updateById(label);
    return 1 == i;
  }

  public Label selectById(String id){
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(Label::getId, ids)
        .set(Label::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(Label::getId, ids)
        .set(Label::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
