package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsDetailVo;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefitsDetail;
import com.biz.crm.member.business.member.local.mapper.LevelManageBenefitsDetailMapper;
import com.biz.crm.member.business.member.sdk.dto.LevelManageBenefitsDetailPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 等级管理-权益配置明细(repository)
 *
 * @author zouhs
 * @date 2023-06-13 09:52:24
 */
@Component
public class LevelManageBenefitsDetailRepository extends ServiceImpl<LevelManageBenefitsDetailMapper, LevelManageBenefitsDetail> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<LevelManageBenefitsDetailVo> findByConditions(Page<LevelManageBenefitsDetailVo> page, LevelManageBenefitsDetailPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public LevelManageBenefitsDetail findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<LevelManageBenefitsDetail> findByIds(List<String> ids) {
    return this.lambdaQuery().in(LevelManageBenefitsDetail::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(LevelManageBenefitsDetail::getId, ids)
        .set(LevelManageBenefitsDetail::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(LevelManageBenefitsDetail::getId, ids)
        .set(LevelManageBenefitsDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
