package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsVo;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefits;
import com.biz.crm.member.business.member.local.mapper.LevelManageBenefitsMapper;
import com.biz.crm.member.business.member.sdk.dto.LevelManageBenefitsPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 等级管理-权益配置(repository)
 *
 * @author zouhs
 * @date 2023-06-13 09:52:00
 */
@Component
public class LevelManageBenefitsRepository extends ServiceImpl<LevelManageBenefitsMapper, LevelManageBenefits> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<LevelManageBenefitsVo> findByConditions(Page<LevelManageBenefitsVo> page, LevelManageBenefitsPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public LevelManageBenefits findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<LevelManageBenefits> findByIds(List<String> ids) {
    return this.lambdaQuery().in(LevelManageBenefits::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(LevelManageBenefits::getId, ids)
        .set(LevelManageBenefits::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(LevelManageBenefits::getId, ids)
        .set(LevelManageBenefits::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
