package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.local.entity.LevelManage;
import com.biz.crm.member.business.member.local.mapper.LevelManageMapper;
import com.biz.crm.member.business.member.sdk.dto.LevelManagePaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 等级管理(repository)
 *
 * @author zouhs
 * @date 2023-06-13 09:51:35
 */
@Component
public class LevelManageRepository extends ServiceImpl<LevelManageMapper, LevelManage> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<LevelManageVo> findByConditions(Page<LevelManageVo> page, LevelManagePaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public LevelManage findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<LevelManage> findByIds(List<String> ids) {
    return this.lambdaQuery().in(LevelManage::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(LevelManage::getId, ids)
        .set(LevelManage::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(LevelManage::getId, ids)
//        .set(LevelManage::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .remove();
  }

  public List<LevelManage> checkGrow(LevelManageVo levelManageVo) {
    return this.baseMapper.checkGrow(levelManageVo);
  }
}
