package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoArchivesVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoArchives;
import com.biz.crm.member.business.member.local.mapper.MemberInfoArchivesMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoArchivesPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员档案(repository)
 *
 * @author zouhs
 * @date 2023-06-19 14:32:22
 */
@Component
public class MemberInfoArchivesRepository extends ServiceImpl<MemberInfoArchivesMapper, MemberInfoArchives> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoArchivesVo> findByConditions(Page<MemberInfoArchivesVo> page, MemberInfoArchivesPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoArchives findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoArchives> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoArchives::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoArchives::getId, ids)
        .set(MemberInfoArchives::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoArchives::getId, ids)
        .set(MemberInfoArchives::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
