package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.dto.BenefitsRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.MemberInfoBenefitsStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.MemberInfoMemberBenefitsTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoBenefitsVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoBenefits;
import com.biz.crm.member.business.member.local.mapper.MemberInfoBenefitsMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoBenefitsPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefits;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefitsReqVo;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员权益关联表(repository)
 *
 * @author zouhs
 * @date 2023-06-20 15:08:40
 */
@Component
public class MemberInfoBenefitsRepository extends ServiceImpl<MemberInfoBenefitsMapper, MemberInfoBenefits> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoBenefitsVo> findByConditions(Page<MemberInfoBenefitsVo> page, MemberInfoBenefitsPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoBenefits findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoBenefits> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoBenefits::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoBenefits::getId, ids)
        .set(MemberInfoBenefits::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoBenefits::getId, ids)
        .set(MemberInfoBenefits::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  public Page<AppletMemberInfoBenefits> getMemberInfoBenefitsList(Page<AppletMemberInfoBenefits> page, AppletMemberInfoBenefitsReqVo dto) {
    return this.baseMapper.getMemberInfoBenefitsList(page,dto);
  }

  /**
   * 根据条件分页获取权限记录
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoBenefitsVo> pageByConditions(Page<MemberInfoBenefitsVo> page, BenefitsRecordPaginationDto dto) {
    return baseMapper.pageByConditions(page,
        dto,
        DelFlagStatusEnum.NORMAL.getCode(),
        MemberInfoMemberBenefitsTypeEnum.MEMBER_BENEFITS.getValue());
  }
}
