package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordDetailVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoComeBackRecordDetail;
import com.biz.crm.member.business.member.local.mapper.MemberInfoComeBackRecordDetailMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoComeBackRecordDetailPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员退货记录明细(repository)
 *
 * @author zouhs
 * @date 2023-06-28 16:57:10
 */
@Component
public class MemberInfoComeBackRecordDetailRepository extends ServiceImpl<MemberInfoComeBackRecordDetailMapper, MemberInfoComeBackRecordDetail> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoComeBackRecordDetailVo> findByConditions(Page<MemberInfoComeBackRecordDetailVo> page, MemberInfoComeBackRecordDetailPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoComeBackRecordDetail findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoComeBackRecordDetail> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoComeBackRecordDetail::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoComeBackRecordDetail::getId, ids)
        .set(MemberInfoComeBackRecordDetail::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoComeBackRecordDetail::getId, ids)
        .set(MemberInfoComeBackRecordDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
