package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoComeBackRecord;
import com.biz.crm.member.business.member.local.mapper.MemberInfoComeBackRecordMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoComeBackRecordPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员退货记录(repository)
 *
 * @author zouhs
 * @date 2023-06-28 16:56:23
 */
@Component
public class MemberInfoComeBackRecordRepository extends ServiceImpl<MemberInfoComeBackRecordMapper, MemberInfoComeBackRecord> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoComeBackRecordVo> findByConditions(Page<MemberInfoComeBackRecordVo> page, MemberInfoComeBackRecordPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoComeBackRecord findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoComeBackRecord> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoComeBackRecord::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoComeBackRecord::getId, ids)
        .set(MemberInfoComeBackRecord::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoComeBackRecord::getId, ids)
        .set(MemberInfoComeBackRecord::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
