package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoContactVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoContact;
import com.biz.crm.member.business.member.local.mapper.MemberInfoContactMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoContactPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 业务员联系人(repository)
 *
 * @author zouhs
 * @date 2023-06-19 14:33:17
 */
@Component
public class MemberInfoContactRepository extends ServiceImpl<MemberInfoContactMapper, MemberInfoContact> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoContactVo> findByConditions(Page<MemberInfoContactVo> page, MemberInfoContactPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoContact findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoContact> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoContact::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoContact::getId, ids)
        .set(MemberInfoContact::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoContact::getId, ids)
        .set(MemberInfoContact::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
