package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.dto.GrowRecordAPIPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationAPIDto;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoGrowRecord;
import com.biz.crm.member.business.member.local.mapper.MemberInfoGrowRecordMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoGrowRecordPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员成长值变动记录(repository)
 *
 * @author zouhs
 * @date 2023-06-19 14:33:37
 */
@Component
public class MemberInfoGrowRecordRepository extends ServiceImpl<MemberInfoGrowRecordMapper, MemberInfoGrowRecord> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoGrowRecordVo> findByConditions(Page<MemberInfoGrowRecordVo> page, MemberInfoGrowRecordPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoGrowRecord findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoGrowRecord> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoGrowRecord::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoGrowRecord::getId, ids)
        .set(MemberInfoGrowRecord::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoGrowRecord::getId, ids)
        .set(MemberInfoGrowRecord::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<GrowRecordAPIVo> findByConditionsAPI(Page<GrowRecordAPIVo> page, GrowRecordAPIPaginationDto dto) {
    return this.baseMapper.findByConditionsAPI(page, dto);
  }
}
