package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationAPIDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoIntegralRecord;
import com.biz.crm.member.business.member.local.mapper.MemberInfoIntegralRecordMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationDto;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

/**
 * 会员积分变动记录(repository)
 *
 * @author zouhs
 * @date 2023-06-19 14:34:02
 */
@Component
public class MemberInfoIntegralRecordRepository extends ServiceImpl<MemberInfoIntegralRecordMapper, MemberInfoIntegralRecord> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoIntegralRecordVo> findByConditions(Page<MemberInfoIntegralRecordVo> page, MemberInfoIntegralRecordPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 小程序分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoIntegralRecordAPIVo> findByConditionsAPI(Page<MemberInfoIntegralRecordAPIVo> page, MemberInfoIntegralRecordPaginationAPIDto dto) {
    return this.baseMapper.findByConditionsAPI(page, dto);
  }

  public MemberInfoIntegralRecord findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoIntegralRecord> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoIntegralRecord::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoIntegralRecord::getId, ids)
        .set(MemberInfoIntegralRecord::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoIntegralRecord::getId, ids)
        .set(MemberInfoIntegralRecord::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  public int sumResidualIntegral(String memberCode, Date timeOpen, Date timeClose) {
    return Optional.ofNullable(this.baseMapper.sumResidualIntegral(memberCode,timeOpen,timeClose)).orElse(0);
  }

  /**
   * 根据记录类型和时间统计积分
   * @param addType
   * @param currentTime
   * @return
   */
  public int sumIntegralByTypeAndTime(List<String> addType, String currentTime) {
    return baseMapper.sumIntegralByTypeAndTime(addType, currentTime,
        DelFlagStatusEnum.NORMAL.getCode());
  }
}
