package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoLevelChangeRecord;
import com.biz.crm.member.business.member.local.mapper.MemberInfoLevelChangeRecordMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoLevelChangeRecordPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员等级变动记录(repository)
 *
 * @author zouhs
 * @date 2023-06-19 14:34:22
 */
@Component
public class MemberInfoLevelChangeRecordRepository extends ServiceImpl<MemberInfoLevelChangeRecordMapper, MemberInfoLevelChangeRecord> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoLevelChangeRecordVo> findByConditions(Page<MemberInfoLevelChangeRecordVo> page, MemberInfoLevelChangeRecordPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoLevelChangeRecord findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoLevelChangeRecord> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoLevelChangeRecord::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoLevelChangeRecord::getId, ids)
        .set(MemberInfoLevelChangeRecord::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoLevelChangeRecord::getId, ids)
        .set(MemberInfoLevelChangeRecord::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
